<!DOCTYPE html>
<!--[if lt IE 7 ]>
<html class="ie ie6" lang="en"> <![endif]-->
<!--[if IE 7 ]>
<html class="ie ie7" lang="en"> <![endif]-->
<!--[if IE 8 ]>
<html class="ie ie8" lang="en"> <![endif]-->
<!--[if (gte IE 9)|!(IE)]><!-->
<html class="no-js" lang="en" <?php if(session()->get('rtl') == 1): ?> dir="rtl" <?php endif; ?> >

<head>
    <meta charset="utf-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge"/>
    <meta http-equiv='X-UA-Compatible' content='IE=edge,chrome=1'/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <title><?php echo app('translator')->get(basicControl()->site_title??"HYIP PRO"); ?> | <?php if(isset($pageSeo['page_title'])): ?><?php echo app('translator')->get($pageSeo['page_title']); ?><?php else: ?>
            <?php echo $__env->yieldContent('title'); ?><?php endif; ?>
    </title>


    <!-- Favicons -->
    <link href="<?php echo e(getFile(basicControl()->favicon_driver??'local', basicControl()->favicon??null)); ?>" rel="icon">

    <meta content="<?php echo e(isset($pageSeo['meta_description']) ? $pageSeo['meta_description'] : ''); ?>" name="description">
    <meta content="<?php echo e(is_array(@$pageSeo['meta_keywords']) ? implode(', ', @$pageSeo['meta_keywords']) : @$pageSeo['meta_keywords']); ?>"
          name="keywords">
    <meta name="theme-color" content="<?php echo e(basicControl()->primary_color); ?>">
    <meta name="author" content="<?php echo e(basicControl()->site_title??"HYIP PRO"); ?>">
    <meta name="robots" content="<?php echo e(isset($pageSeo['meta_robots']) ? $pageSeo['meta_robots'] : ''); ?>">

    <meta property="og:type" content="website">
    <meta property="og:site_name" content="<?php echo e(isset(basicControl()->site_title) ? basicControl()->site_title??"HYIP PRO" : ''); ?>">
    <meta property="og:title" content="<?php echo e(isset($pageSeo['meta_title']) ? $pageSeo['meta_title'] : ''); ?>">
    <meta property="og:description" content="<?php echo e(isset($pageSeo['og_description']) ? $pageSeo['og_description'] : ''); ?>">
    <meta property="og:image" content="<?php echo e(isset($pageSeo['meta_image']) ? $pageSeo['meta_image'] : ''); ?>">

    <meta name="twitter:card" content="<?php echo e(isset($pageSeo['meta_title']) ? $pageSeo['meta_title'] : ''); ?>">
    <meta name="twitter:title" content="<?php echo e(isset($pageSeo['meta_title']) ? $pageSeo['meta_title'] : ''); ?>">
    <meta name="twitter:description" content="<?php echo e(isset($pageSeo['meta_description']) ? $pageSeo['meta_description'] : ''); ?>">
    <meta name="twitter:image" content="<?php echo e(isset($pageSeo['meta_image']) ? $pageSeo['meta_image'] : ''); ?>">


    <link rel="stylesheet" type="text/css" href="<?php echo e(asset(template(true).'css/bootstrap.min.css')); ?>"/>

    <?php echo $__env->yieldPushContent('css-lib'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/admin/css/fontawesome.min.css')); ?>" />
    <!-- owl carousel -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset(template(true).'css/owl.carousel.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset(template(true).'css/owl.theme.default.min.css')); ?>">

    <!-- select 2 -->
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset(template(true).'css/select2.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset(template(true).'css/fancybox.css')); ?>">

    <link rel="stylesheet" type="text/css" href="<?php echo e(asset(template(true).'css/all.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset(template(true).'css/fontawesome.min.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset(template(true).'css/style.css')); ?>">
    <script src="<?php echo e(asset('assets/global/js/notiflix-aio-3.2.6.min.js')); ?>"></script>
    <script src="<?php echo e(asset(template(true).'js/modernizr.custom.js')); ?>"></script>

    <?php echo $__env->yieldPushContent('style'); ?>

    <!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 9]>
    <script type="application/javascript" src="https://oss.maxcdn.com/html5shiv/3.7.2/html5shiv.min.js"></script>
    <script type="application/javascript" src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
    <![endif]-->
</head>

<body>


<!-- main top navbar big device -->
<nav class="navbar navbar-expand-lg fixed-top">
    <div class="container">
        <a class="navbar-brand" href="<?php echo e(route('page')); ?>"> <img
                src="<?php echo e(logo()); ?>" alt=""></a>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav">
                <?php echo renderHeaderMenu(getHeaderMenuData()); ?>


                <?php if(auth()->guard()->guest()): ?>
                    <li class="nav-item">
                        <a class="nav-link <?php echo e(Request::routeIs('login') ? 'active' : ''); ?>" href="<?php echo e(route('login')); ?>">
                            <?php echo app('translator')->get('Login'); ?>
                        </a>
                    </li>
                <?php endif; ?>
            </ul>

        </div>
        <!-- navbar text -->
        <div class="navbar-text" id="pushNotificationArea">
            <?php if(auth()->guard()->check()): ?>
                <!-- notification panel -->
                
                <?php echo $__env->make(template().'partials.pushNotify', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                
            <?php endif; ?>

            <?php if(auth()->guard()->check()): ?>
                <div class="notification-panel user-panel">
               <span class="profile">
                  <img src="<?php echo e(getFile(auth()->user()->image_driver,auth()->user()->image)); ?>" class="img-fluid"
                       alt="<?php echo app('translator')->get('user img'); ?>"/>
               </span>
                    <ul class="user-dropdown">
                        <li>
                            <a href="<?php echo e(route('user.dashboard')); ?>"> <i class="fal fa-border-all"
                                                                 aria-hidden="true"></i> <?php echo app('translator')->get('Dashboard'); ?> </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('user.profile')); ?>"> <i class="fal fa-user"></i> <?php echo app('translator')->get('My Profile'); ?> </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('user.twostep.security')); ?>"> <i
                                    class="fal fa-key"></i> <?php echo app('translator')->get('2FA Security'); ?> </a>
                        </li>
                        <li>
                            <a href="<?php echo e(route('logout')); ?>" onclick="event.preventDefault();
                        document.getElementById('logout-form').submit();"> <i
                                    class="fal fa-sign-out-alt"></i> <?php echo app('translator')->get('Log Out'); ?> </a>
                            <form id="logout-form" action="<?php echo e(route('logout')); ?>" method="POST" class="d-none">
                                <?php echo csrf_field(); ?>
                            </form>
                        </li>
                    </ul>
                </div>
            <?php endif; ?>
        </div>
    </div>
</nav>


<?php echo $__env->make(template().'partials.banner', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<?php echo $__env->yieldContent('content'); ?>

<?php echo $__env->make(template().'partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<script src="<?php echo e(asset(template(true).'js/bootstrap.bundle.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/jquery-3.6.0.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/owl.carousel.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/select2.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/fancybox.umd.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/socialSharing.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/apexcharts.min.js')); ?>"></script>
<!-- counter up -->
<script src="<?php echo e(asset(template(true).'js/jquery.counterup.min.js')); ?>"></script>

<script src="<?php echo e(asset('assets/global/js/notiflix-aio-3.2.6.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/pusher.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/vue.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/global/js/axios.min.js')); ?>"></script>
<script src="<?php echo e(asset(template(true).'js/script.js')); ?>"></script>

<?php echo $__env->yieldPushContent('js-lib'); ?>

<?php echo $__env->yieldPushContent('script'); ?>

<script>
    "use strict";
    $(document).on('click', '.investNow', function () {
        var planModal = new bootstrap.Modal(document.getElementById('investModal'));
        planModal.show()
        let data = $(this).data('resource');
        console.log(data);
        let price = $(this).data('price');
        let symbol = "<?php echo e(basicControl()->currency_symbol); ?>";
        let currency = "<?php echo e(basicControl()->base_currency); ?>";
        $('.price-range').text(`<?php echo app('translator')->get('Invest'); ?>: ${price}`);

        if (data.fixed_amount == '0') {
            $('.invest-amount').val('');
            $('#amount').attr('readonly', false);
        } else {
            $('.invest-amount').val(data.fixed_amount);
            $('#amount').attr('readonly', true);
        }

        $('.profit-details').html(`<?php echo app('translator')->get('Interest'); ?>: ${(data.profit_type == '1') ? `${data.profit} %` : `${data.profit} ${currency}`}`);
        $('.profit-validity').html(`<?php echo app('translator')->get('Per'); ?> ${data.schedule} <?php echo app('translator')->get('hours'); ?> ,  ${(data.is_lifetime == '0') ? `${data.repeatable} <?php echo app('translator')->get('times'); ?>` : `<?php echo app('translator')->get('Lifetime'); ?>`}`);
        $('.plan-name').text(data.name);
        $('.plan-id').val(data.id);
        $('.show-currency').text("<?php echo e(basicControl()->base_currency); ?>");
    });
</script>

<script>
    var root = document.querySelector(':root');
    root.style.setProperty('--primary', '<?php echo e(primaryColor()??'#46aeeb'); ?>');
    root.style.setProperty('--secondary', '<?php echo e(secondaryColor()??'#46aeeb'); ?>');
</script>

<?php if(session()->has('success')): ?>
    <script>
        Notiflix.Notify.success("<?php echo app('translator')->get(session('success')); ?>");
    </script>
<?php endif; ?>

<?php if(session()->has('error')): ?>
    <script>
        Notiflix.Notify.failure("<?php echo app('translator')->get(session('error')); ?>");
    </script>
<?php endif; ?>

<?php if(session()->has('warning')): ?>
    <script>
        Notiflix.Notify.warning("<?php echo app('translator')->get(session('warning')); ?>");
    </script>
<?php endif; ?>

<?php echo $__env->make('plugins', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</body>

</html>
<?php /**PATH D:\server\htdocs\hyip_8\demo\resources\views/themes/dodgerblue/layouts/app.blade.php ENDPATH**/ ?>